/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.gui;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelpers {
    private static final String ELLIPSES = "...";

    public static Collection<ITextComponent> getTrimmedTextCollection(@Nonnull String key, int width, TextFormatting ... formatting) {
        Style style = GuiHelpers.prefixHelper(formatting);
        return GameUtils.getMC().field_71466_p.func_238420_b_().func_238362_b_((ITextProperties)new TranslationTextComponent(key), width, style).stream().map(e -> new StringTextComponent(e.getString())).collect(Collectors.toList());
    }

    public static ITextComponent getTrimmedText(@Nonnull String key, int width, TextFormatting ... formatting) {
        Style style = GuiHelpers.prefixHelper(formatting);
        TranslationTextComponent text = new TranslationTextComponent(key);
        FontRenderer fr = GameUtils.getMC().field_71466_p;
        CharacterManager cm = fr.func_238420_b_();
        if (fr.func_238414_a_((ITextProperties)text) > width) {
            int ellipsesWidth = fr.func_78256_a(ELLIPSES);
            int trueWidth = width - ellipsesWidth;
            ITextProperties str = cm.func_238358_a_((ITextProperties)text, trueWidth, style);
            return new StringTextComponent(str.getString() + ELLIPSES);
        }
        ITextProperties str = cm.func_238358_a_((ITextProperties)text, width, style);
        return new StringTextComponent(str.getString());
    }

    private static Style prefixHelper(@Nullable TextFormatting[] formatting) {
        Style style = formatting != null && formatting.length > 0 ? Style.field_240709_b_.func_240720_a_(formatting) : Style.field_240709_b_;
        return style;
    }
}

